<?php
if (!defined('ABSPATH')) exit;

/**
 * صفحه تنظیمات API / لایسنس (کلاینت)
 * رفتار:
 * - هر بار باز/ریفِرش صفحه: چک IP به‌صورت سخت‌گیرانه (require_ip=1) و بدون کش
 * - اگر IP مجاز بود: پیام «مجاز» و فرم لایسنس فقط نمایشی (ورودی و دکمه ذخیره هردو غیرفعال)
 *   و **دکمهٔ خرید/تمدید نمایش داده نمی‌شود**.
 * - اگر IP مجاز نبود: فقط در این حالت لایسنس چک می‌شود؛
 *   و **دکمهٔ خرید/تمدید نمایش داده می‌شود**.
 */

/* ---------- Gregorian <-> Jalali ---------- */
if (!function_exists('_vps7_g2j_php')) {
    function _vps7_g2j_php($gy,$gm,$gd,$as_string=true){
        $gdm=array(31,28,31,30,31,30,31,31,30,31,30,31);
        $jdm=array(31,31,31,31,31,31,30,30,30,30,30,29);
        $gy2=$gy-1600; $gm2=$gm-1; $gd2=$gd-1;
        $g_day_no=365*$gy2+intdiv($gy2+3,4)-intdiv($gy2+99,100)+intdiv($gy2+399,400);
        for($i=0;$i<$gm2;++$i) $g_day_no+=$gdm[$i];
        if($gm2>1 && (($gy%4==0 && $gy%100!=0)||($gy%400==0))) $g_day_no++;
        $g_day_no+=$gd2;
        $j_day_no=$g_day_no-79;
        $j_np=intdiv($j_day_no,12053); $j_day_no%=12053;
        $jy=979+33*$j_np+4*intdiv($j_day_no,1461);
        $j_day_no%=1461;
        if($j_day_no>=366){ $jy+=intdiv($j_day_no-1,365); $j_day_no=($j_day_no-1)%365; }
        for($i=0;$i<11 && $j_day_no>=$jdm[$i];++$i) $j_day_no-=$jdm[$i];
        $jm=$i+1; $jd=$j_day_no+1;
        return $as_string ? sprintf('%04d/%02d/%02d',$jy,$jm,$jd) : array($jy,$jm,$jd);
    }
}
if (!function_exists('_vps7_j2g_php')) {
    function _vps7_j2g_php($jy,$jm,$jd,$as_string=true){
        $gdm=array(31,28,31,30,31,30,31,31,30,31,30,31);
        $jdm=array(31,31,31,31,31,31,30,30,30,30,30,29);
        $jy2=$jy-979; $jm2=$jm-1; $jd2=$jd-1;
        $j_day_no=365*$jy2+intdiv($jy2,33)*8+intdiv(($jy2%33)+3,4);
        for($i=0;$i<$jm2;++$i) $j_day_no+=$jdm[$i];
        $j_day_no+=$jd2;
        $g_day_no=$j_day_no+79;
        $gy=1600+400*intdiv($g_day_no,146097); $g_day_no%=146097;
        $leap=true;
        if($g_day_no>=36525){ $g_day_no--; $gy+=100*intdiv($g_day_no,36524); $g_day_no%=36524; if($g_day_no>=365) $g_day_no++; else $leap=false; }
        $gy+=4*intdiv($g_day_no,1461); $g_day_no%=1461;
        if($g_day_no>=366){ $leap=false; $g_day_no--; $gy+=intdiv($g_day_no,365); $g_day_no%=365; }
        for($i=0; $g_day_no>=($gdm[$i]+($i==1 && $leap)); $i++) $g_day_no-=$gdm[$i]+($i==1 && $leap);
        $gm=$i+1; $gd=$g_day_no+1;
        return $as_string ? sprintf('%04d-%02d-%02d',$gy,$gm,$gd) : array($gy,$gm,$gd);
    }
}

/* ---------- Helpers ---------- */
if (!function_exists('_vps7_to_array')) {
    function _vps7_to_array($m){ return is_array($m) ? $m : (is_object($m) ? (array)$m : array()); }
}
if (!function_exists('_vps7_period_label_fa_from_code')) {
    function _vps7_period_label_fa_from_code($x){
        $x = strtolower(trim((string)$x));
        $map = array(
            'hour'=>'ساعتی','day'=>'روزانه','week'=>'هفتگی','month'=>'ماهانه','year'=>'سالانه',
            'h'=>'ساعتی','d'=>'روزانه','w'=>'هفتگی','m'=>'ماهانه','y'=>'سالانه'
        );
        return $map[$x] ?? $x;
    }
}

/* ---------- صفحه تنظیمات ---------- */
function vps7_render_api_settings($client){
    if (!current_user_can('install_plugins')) {
        echo '<div class="wrap"><h1>تنظیمات API</h1><p>دسترسی ندارید.</p></div>';
        return;
    }

    $s   = array('server_base'=>VPS7_Repository_Client::SERVER_BASE, 'api_base'=>VPS7_Repository_Client::API_BASE);
    $opt = VPS7_Repository_Client::OPT_LICENSE;
    $api = rtrim($s['server_base'], '/') . '/' . ltrim($s['api_base'], '/');

    $license = get_option($opt, '');
    $domain  = parse_url(site_url(), PHP_URL_HOST);

    /* ذخیره/تأیید لایسنس (وقتی ورودی داده می‌شود) */
    if (!empty($_POST['vps7_save_lic'])) {
        check_admin_referer('vps7_save_lic_nonce');
        $new = isset($_POST['vps7_license']) ? sanitize_text_field($_POST['vps7_license']) : '';
        if ($new) {
            $res = $client->remote_post($api.'/verify-license', array(
                'license'=>$new,'domain'=>$domain,'nocache'=>uniqid('',true)
            ));
            if (is_array($res) && !empty($res['ok'])) {
                update_option($opt, $new);
                $license = $new;
                echo '<div class="updated notice"><p>לایسنس با موفقیت تأیید و ذخیره شد.</p></div>';
            } else {
                echo '<div class="error notice"><p>لایسنس نامعتبر است.</p></div>';
            }
        } else {
            echo '<div class="error notice"><p>لطفاً کد لایسنس را وارد کنید.</p></div>';
        }
    }

    /* --- چک سخت‌گیرانه IP در هر بار رندر (بدون کش) --- */
    $allowed = false;
    $via     = '';
    $reason  = '';

    // 1) IP strict
    $probe_ip = $client->remote_get($api.'/access', array(
        'intent'     => 'connect',
        'consume'    => 0,
        'require_ip' => 1,
        'domain'     => $domain,
        'nocache'    => uniqid('', true),
    ));

    if (is_array($probe_ip) && !empty($probe_ip['allowed']) && strtolower((string)($probe_ip['via'] ?? 'ip')) === 'ip') {
        $allowed = true;
        $via     = 'ip';
    } else {
        // اگر IP مجاز نبود، فقط در این حالت لایسنس را چک کن
        if (!empty($license)) {
            $acc = $client->remote_get($api.'/access', array(
                'license'=>$license,'domain'=>$domain,'intent'=>'connect','consume'=>0,'nocache'=>uniqid('',true)
            ));

            // اگر سرور گفت لایسنس باید پاک شود (fatal/domain_unbound)، همان‌جا حذف کن
            if (is_array($acc) && ( !empty($acc['fatal']) || !empty($acc['domain_unbound']) )) {
                delete_option($opt);
                $license = '';
                echo '<div class="notice notice-error"><p>לایسنس این سایت از سمت سرور نامعتبر/آزاد شد و از سیستم پاک گردید. لطفاً دوباره لایسنس را ثبت کنید.</p></div>';
            }

            if (is_array($acc) && !empty($acc['allowed'])) {
                $allowed = true;
                $via     = 'license';
            } else {
                $allowed = false;
                $via     = 'license';
                if (is_array($acc) && !empty($acc['reason'])) $reason = (string)$acc['reason'];
                if (is_array($probe_ip) && empty($reason) && !empty($probe_ip['reason'])) $reason = (string)$probe_ip['reason'];
            }
        } else {
            // لایسنس هم نداریم → غیر مجاز
            $allowed = false;
            $via     = 'ip';
            if (is_array($probe_ip) && !empty($probe_ip['reason'])) $reason = (string)$probe_ip['reason'];
        }
    }

    echo '<div class="wrap vps7-page"><h1>تنظیمات API / لایسنس</h1>';

    // پیام وضعیت
    if ($allowed && $via==='ip') {
        echo '<p class="vps7-green" style="font-weight:600">دسترسی شما مجاز است (بر اساس آی‌پی). نیازی به ثبت لایسنس نیست.</p>';
    } elseif ($allowed && $via==='license') {
        echo '<p class="vps7-green">دسترسی شما با لایسنس مجاز شده است.</p>';
    } else {
        $msg = 'دسترسی فعلاً مجاز نیست';
        if ($reason) $msg .= ' — ' . esc_html($reason);
        $msg .= '.<br><br>برای استفاده بدون آی‌پی مجاز، باید لایسنس معتبر ثبت کنید یا لایسنس را خرید/تمدید نمایید.';
        echo '<p class="vps7-red">'.$msg.'</p>';
    }

    // فرم لایسنس
    echo '<form method="post" style="margin-top:10px; display:flex; gap:8px; align-items:center; flex-wrap:wrap;">';

    if ($allowed && $via==='ip') {
        // حالت IP مجاز: فرم فقط نمایشی + دکمه ذخیره غیرفعال، و «خرید/تمدید» نمایش داده نمی‌شود
        wp_nonce_field('vps7_save_lic_nonce');
        $val = $license ? esc_attr($license) : '';
        echo '<input type="text" class="regular-text" value="'.$val.'" placeholder="کد لایسنس (اختیاری)" readonly disabled />';
        // دکمه ذخیره غیرفعال
        submit_button(
            'بررسی و ذخیره',
            'primary',
            'vps7_save_lic',
            false,
            array('disabled'=>'disabled','aria-disabled'=>'true','title'=>'آی‌پی مجاز است؛ نیازی به ثبت لایسنس نیست')
        );
        // عمداً لینک خرید/تمدید را در این حالت نمایش نمی‌دهیم
    } else {
        // IP مجاز نیست → فرم عادی و لینک خرید/تمدید
        if (empty($license)) {
            wp_nonce_field('vps7_save_lic_nonce');
            echo '<input type="text" name="vps7_license" class="regular-text" placeholder="کد لایسنس" value="" />';
            submit_button('بررسی و ذخیره', 'primary', 'vps7_save_lic', false);
            echo '<a class="button button-primary" target="_blank" href="'.esc_url('https://vps7.net/').'">خرید / تمدید لایسنس</a>';
        } else {
            echo '<input type="text" class="regular-text" value="'.esc_attr($license).'" readonly disabled />';
            echo '<a href="#" id="vps7_remove_lic" class="button">حذف لایسنس</a>';
            echo '<a class="button button-primary" target="_blank" href="'.esc_url('https://vps7.net/').'">خرید / تمدید لایسنس</a>';
        }
    }
    echo '</form>';

    /* جدول اطلاعات لایسنس (فقط وقتی لایسنس ذخیره است) */
    if (!empty($license)) {
        $info = $client->remote_get($api.'/license-info', array(
            'license'=>$license,'domain'=>$domain,'nocache'=>uniqid('',true)
        ));
        $lic  = isset($info['license']) ? _vps7_to_array($info['license']) : _vps7_to_array($info);

        // --- تاریخ پایان ---
        $end_raw = '';
        foreach (array('end_at','expires_at','expire_at','expiry') as $k) {
            if (!empty($lic[$k])) { $end_raw = (string) $lic[$k]; break; }
        }
        $end_fa = '—';
        $days_left = '—';
        if ($end_raw) {
            $end_raw_trim = trim($end_raw);
            if (preg_match('/^\d{4}[-\/]\d{2}[-\/]\d{2}/', $end_raw_trim)) {
                $date_part = preg_split('/[ T]/', $end_raw_trim)[0];
                if (strpos($date_part,'/') !== false) $date_part = str_replace('/','-',$date_part);
                list($gy,$gm,$gd) = array_map('intval', explode('-', $date_part));
                $end_fa = _vps7_g2j_php($gy,$gm,$gd,true);
                try {
                    $end_dt = new DateTime(sprintf('%04d-%02d-%02d 23:59:59',$gy,$gm,$gd), wp_timezone());
                    $now_dt = new DateTime('now', wp_timezone());
                    $diff   = (int) floor(($end_dt->getTimestamp() - $now_dt->getTimestamp()) / DAY_IN_SECONDS);
                    $days_left = ($diff < 0) ? 'منقضی شده' : ($diff.' روز');
                } catch (Exception $e) {}
            }
        }

        echo '<div class="vps7-lic-table" style="margin-top:14px">';
        echo '<table style="border-collapse: collapse; width: 100%; max-width:720px; text-align:right; direction:rtl; font-size:14px"><tbody>';
        echo '<tr style="background:#f5f5f5"><th style="width:220px; border:1px solid #ccc; padding:8px;">تاریخ پایان لایسنس</th><td style="border:1px solid #ccc; padding:8px;">'.esc_html($end_fa).'</td></tr>';
        echo '<tr><th style="border:1px solid #ccc; padding:8px;">روز باقی‌مانده</th><td style="border:1px solid #ccc; padding:8px;">'.esc_html($days_left).'</td></tr>';
        echo '</tbody></table>';
        echo '</div>';

        // اگر دسترسی رد شده بود و reason داریم، پیام خطا
        if (!$allowed && !empty($reason)) {
            echo '<div class="notice notice-error" style="margin-top:10px"><p>'.esc_html($reason).'</p></div>';
        }
    }

    // حذف لایسنس
    ?>
    <script>
    (function($){
        $(document).on('click', '#vps7_remove_lic', function(e){
            e.preventDefault();
            if(!confirm('لایسنس حذف شود؟')) return;
            $.post(ajaxurl, { action:'vps7_remove_license', nonce:'<?php echo esc_js( wp_create_nonce('vps7_nonce') ); ?>' }, function(res){
                if(res && res.success){ location.reload(); }
                else { alert('خطا در حذف لایسنس'); }
            }).fail(function(){ alert('ارتباط برقرار نشد.'); });
        });
    })(jQuery);
    </script>
    <?php

    echo '</div>'; // .wrap
}
echo '<style>
    #vps7_remove_lic { color: white; background-color: red; }
	.vps7-green { color: green; font-weight:600; }
	.vps7-red { color: red; font-weight:600; }
</style>';
