<?php
/**
 * JE Repository - Details modal (tabs)
 * CSS/JS مستقل برای پنجره «جزئیات» آیتم‌ها (پلاگین/قالب)
 */
if (!defined('ABSPATH')) exit;

add_action('admin_enqueue_scripts', function($hook){
    // فقط صفحات کلاینت مخزن
    if (strpos($hook, 'vps7_') === false && strpos($hook, 'page_vps7_updates') === false) return;

    /* ---------- CSS ---------- */
    wp_register_style('vps7-details-css', false, array(), '1.0.10');
    wp_enqueue_style('vps7-details-css');

    $css = <<<CSS
/* فونت یکدست */
.vps7-modal, .vps7-modal *{font-family:'Vazirmatn', Vazirmatn, sans-serif !important}
/* ظرف مودال */
.vps7-modal{position:fixed;inset:0;display:none;align-items:center;justify-content:center;background:rgba(0,0,0,.45);z-index:9999}
.vps7-modal .box{position:relative;background:#fff;max-width:980px;width:96%;max-height:85vh;overflow:auto;border-radius:12px;padding:16px}
/* دکمه بستن */
#vps7_modal_closeX{
  position:absolute; left:12px; top:12px;
  width:48px; min-width:48px; height:48px; min-height:48px;
  border-radius:12px; background:#f1f5f9; color:#0f172a; border:1px solid #e2e8f0;
  display:flex; align-items:center; justify-content:center;
  font-weight:900; font-size:50px; line-height:1;
  cursor:pointer; box-shadow:0 2px 10px rgba(15,23,42,.08);
  transition:transform .12s ease, background .12s ease, border-color .12s ease;
}
#vps7_modal_closeX:hover, #vps7_modal_closeX:focus{
  transform:scale(1.06);
  background:#eaf0f6; border-color:#cbd5e1; outline:none;
}
#vps7_modal_close{display:none}
/* هدر */
.vps7-details-head{
  display:flex; gap:14px; align-items:flex-start; flex-direction:row-reverse;
}
.vps7-details-head .vps7-details-img{
  width:148px; min-width:148px; height:148px; border-radius:12px; object-fit:cover; border:1px solid #e2e8f0;
}
.vps7-details-head .vps7-details-col{display:flex; flex-direction:column; gap:6px}
.vps7-details-title{margin:0 0 6px 0; font-size:18px; font-weight:800; color:#0f172a}
/* متا/چیپ‌ها */
.vps7-meta{display:flex;gap:8px;flex-wrap:wrap;margin:4px 0 2px 0}
.vps7-meta .badge{
  background:#eef2ff;color:#1e293b;border:1px solid #c7d2fe;
  padding:4px 10px;border-radius:8px;font-weight:700;font-size:12px
}
/* خط و تب‌ها */
.vps7-hr{height:1px;background:#e2e8f0;margin:12px 0}
.vps7-tabsline{display:flex;gap:8px;flex-wrap:wrap;align-items:center;margin-bottom:10px}
.vps7-tabbtn{
  padding:6px 10px;border:1px solid #e2e8f0;border-radius:8px;background:#f8fafc;cursor:pointer;font-weight:700
}
.vps7-tabbtn.active{background:#0f172a;color:#fff;border-color:#0f172a}
/* تب‌ها */
.vps7-tabpanel{display:none}
.vps7-tabpanel.active{display:block}
#vps7_tab_desc img, #vps7_tab_pics img{max-width:95%; height:auto; display:block; margin:10px auto; border-radius:10px}
#vps7_tab_desc{ text-align:justify }
/* گالری */
.vps7-pics-grid{ display:grid; grid-template-columns:repeat(2, minmax(0,1fr)); gap:10px; }
@media (max-width:900px){ .vps7-pics-grid{ grid-template-columns:1fr } }
/* FAQ */
.vps7-acc{border:1px solid #e2e8f0; border-radius:10px; overflow:hidden}
.vps7-acc-item + .vps7-acc-item{border-top:1px solid #e2e8f0}
.vps7-acc-q{ width:100%; text-align:right; background:#f8fafc; border:0; padding:12px; cursor:pointer; font-weight:800 }
.vps7-acc-a{display:none; padding:12px; background:#fff}
.vps7-acc-item.open .vps7-acc-a{display:block}
/* پیش‌نمایش */
.vps7-preview-cta{display:flex;justify-content:center}
.vps7-preview-cta a.button{ font-weight:800; border-radius:10px; }
/* پیام خطا */
.vps7-api-error{background:#fef2f2;border:1px solid #fecaca;color:#991b1b;border-radius:8px;padding:10px;margin:6px 0;font-weight:700}
CSS;
    wp_add_inline_style('vps7-details-css', $css);

    /* ---------- JS ---------- */
    wp_register_script('vps7-details-js', false, array('jquery'), '1.0.10', true);
    wp_enqueue_script('vps7-details-js');

    $js = <<<JS
(function($){

  /* ---------- Helpers ---------- */

  function getApiRoot(){
    if (window.VPS7 && typeof VPS7.apiRoot === 'string' && VPS7.apiRoot.length) return VPS7.apiRoot.replace(/\\/+$/, '');
    var fromList = $('#vps7_list').data('api');
    if (fromList) return String(fromList).replace(/\\/+$/, '');
    var fromAny = $('[data-vps7-api]').first().data('vps7Api');
    if (fromAny) return String(fromAny).replace(/\\/+$/, '');
    var base = $('#vps7_server').val() || $('[name="vps7_server"]').val() || '';
    if (base) return String(base).replace(/\\/+$/, '') + '/wp-json/vps7/v1';
    return '';
  }

  function formatUpdatedAt(v){
    if(!v) return '';
    try{
      var raw = String(v).trim();
      var d = new Date(raw);
      if (isNaN(d.getTime())) d = new Date(raw.replace(' ', 'T'));
      if (isNaN(d.getTime())) return raw.replace('T',' ').replace('Z','').split('+')[0].trim();
      var pad = function(n){ return (n<10?'0':'')+n; };
      return d.getFullYear()+'-'+pad(d.getMonth()+1)+'-'+pad(d.getDate())+' '+pad(d.getHours())+':'+pad(d.getMinutes());
    }catch(e){ return String(v); }
  }

  function toSafe(s){ return (s||''); }

  function openModal(html){
    var m = $('#vps7_modal'); 
    if(!m.length){
      $('body').append('<div class="vps7-modal" id="vps7_modal"><div class="box"><div id="vps7_modal_content"></div><p><button class="button" id="vps7_modal_close">بستن</button></p></div></div>');
      m = $('#vps7_modal');
    }
    $('#vps7_modal_content').html(html);
    m.fadeIn(120).css('display','flex');
  }
  function closeModal(){ $('#vps7_modal').fadeOut(100); }

  /* ---------- UI Events ---------- */

  $(document).on('click','#vps7_modal_closeX', closeModal);
  $(document).on('click','.vps7-modal', function(e){
    if(e.target && e.target.classList && e.target.classList.contains('vps7-modal')) closeModal();
  });
  $(document).on('keydown', function(e){ if(e.key==='Escape') closeModal(); });

  $(document).on('click','.vps7-tabbtn', function(){
    var b = $(this), key = b.data('tab')||'';
    var href = b.data('href')||'';
    b.addClass('active').siblings('.vps7-tabbtn').removeClass('active');
    $('.vps7-tabpanel').removeClass('active');
    if(key==='prev' && href){ window.open(href, '_blank', 'noopener'); return; }
    $('#vps7_tab_'+key).addClass('active');
  });

  $(document).on('click','.vps7-acc-q', function(){
    $(this).closest('.vps7-acc-item').toggleClass('open');
  });

  /* ---------- Modal Builder ---------- */

  function buildModalSkeleton(data){
    var title = toSafe(data.title),
        img   = toSafe(data.img),
        ver   = toSafe(data.ver),
        udate = formatUpdatedAt(toSafe(data.udate)),
        dl    = (data.dl||0),
        excerpt = toSafe(data.excerpt);

    var head =
      '<div class="vps7-details-head">'
      +  '<img class="vps7-details-img" src="'+img+'" alt="">'
      +  '<div class="vps7-details-col">'
      +    '<h2 class="vps7-details-title">'+title+'</h2>'
      +    '<div class="vps7-meta">'
      +      (ver?  '<span class="badge ver" id="vps7_meta_ver">نسخه '+ver+'</span>':'<span class="badge ver" id="vps7_meta_ver" style="display:none"></span>')
      +      (udate?'<span class="badge ud" id="vps7_meta_udate">بروزرسانی '+udate+'</span>':'<span class="badge ud" id="vps7_meta_udate" style="display:none"></span>')
      +      '<span class="badge" id="vps7_meta_dl">دانلود '+dl+'</span>'
      +    '</div>'
      +    (excerpt ? ('<div id="vps7_meta_excerpt" style="margin-top:2px;text-align:justify">'+excerpt+'</div>') : '<div id="vps7_meta_excerpt" style="display:none"></div>')
      +  '</div>'
      +'</div>'
      +'<div class="vps7-hr"></div>';

    var tabs = [
      {key:'desc', title:'توضیحات'},
      {key:'pics', title:'تصاویر'},
      {key:'rel',  title:'موارد مرتبط'},
      {key:'faq',  title:'سوالات متداول'}
    ];
    if(data.isTheme && data.preview){
      tabs.push({key:'prev', title:'پیش‌نمایش', href:data.preview});
    }

    var tabsHtml = '<div class="vps7-tabsline">';
    for(var i=0;i<tabs.length;i++){
      var t = tabs[i];
      tabsHtml += '<button type="button" class="vps7-tabbtn'+(i===0?' active':'')+'" data-tab="'+t.key+'"'
                + (t.href?(' data-href="'+t.href+'"'):'')
                + '>'+t.title+'</button>';
    }
    tabsHtml += '</div>';

    var panels =
      '<div id="vps7_tab_desc" class="vps7-tabpanel active"><div id="vps7_tab_desc_in"></div></div>'
      +'<div id="vps7_tab_pics" class="vps7-tabpanel"><div class="vps7-pics-grid" id="vps7_pics_grid"></div></div>'
      +'<div id="vps7_tab_rel"  class="vps7-tabpanel"><div id="vps7_rel_in"></div></div>'
      +'<div id="vps7_tab_faq"  class="vps7-tabpanel"><div id="vps7_faq_in"></div></div>'
      + (data.isTheme ? '<div id="vps7_tab_prev" class="vps7-tabpanel"><div class="vps7-preview-cta"><a target="_blank" rel="noopener" class="button button-primary" id="vps7_preview_link"'
          + (data.preview?(' href="'+data.preview+'"'):'') + '>مشاهده پیش‌نمایش</a></div></div>' : '');

    var closeX = '<button id="vps7_modal_closeX" aria-label="Close">×</button>';

    return closeX + head + tabsHtml + panels;
  }

  /* ---------- API hydrate ---------- */

  function showApiError(msg){
    var box = $('#vps7_tab_desc_in');
    if (!box.length) return;
    var text = msg || 'خطا در دریافت جزئیات آیتم. لطفاً اتصال/دسترسی (IP/لایسنس) را بررسی کنید.';
    box.append('<div class="vps7-api-error">'+text+'</div>');
  }

  function hydrateFromAPI(id, type){
    var api = getApiRoot();
    if(!api){ showApiError('apiRoot تنظیم نشده است.'); return; }
    if(!id){ showApiError('شناسه آیتم نامعتبر است.'); return; }
    var url = api + (type==='theme'?'/theme':'/plugin');

    $.getJSON(url, {id: id, t: Date.now()})
      .done(function(res){
        if(!res || typeof res!=='object'){ showApiError(); return; }

        // هدر
        if(res.title)      $('.vps7-details-title').text(res.title);
        if(res.thumbnail)  $('.vps7-details-img').attr('src', res.thumbnail);
        if(res.version){   $('#vps7_meta_ver').text('نسخه '+res.version).show(); }
        if(typeof res.downloads!=='undefined'){ $('#vps7_meta_dl').text('دانلود '+res.downloads); }
        if(res.excerpt){   $('#vps7_meta_excerpt').html(res.excerpt).show(); }
        if(res.updated_at){
          var txt = formatUpdatedAt(res.updated_at);
          if (txt) $('#vps7_meta_udate').text('بروزرسانی '+txt).show();
        }

        // گالری
        var gallery = res.gallery || res.images || [];
        if($.isArray(gallery) && gallery.length){
          var html = '';
          for(var i=0;i<gallery.length;i++){
            if(!gallery[i]) continue;
            html += '<img src="'+gallery[i]+'" alt="">';
          }
          $('#vps7_pics_grid').html(html);
        } else {
          $('#vps7_pics_grid').html('<div style="opacity:.7;padding:6px">گالری موجود نیست.</div>');
        }

        // موارد مرتبط
        var rel = res.related_html || res.related || '';
        if(rel){ $('#vps7_rel_in').html(rel); }
        else { $('#vps7_rel_in').html('<div style="opacity:.7;padding:6px">موردی ثبت نشده است.</div>'); }

        // FAQ
        var faq = res.faq || res.faqs || [];
        if($.isArray(faq) && faq.length){
          var fhtml = '<div class="vps7-acc">';
          for(var j=0;j<faq.length;j++){
            var q = toSafe(faq[j] && (faq[j].q||faq[j].question)),
                a = toSafe(faq[j] && (faq[j].a||faq[j].answer));
            if(!q && !a) continue;
            fhtml += '<div class="vps7-acc-item">'
                  +    '<button class="vps7-acc-q">'+(q||('سوال '+(j+1)))+'</button>'
                  +    '<div class="vps7-acc-a">'+(a||'')+'</div>'
                  +  '</div>';
          }
          fhtml += '</div>';
          $('#vps7_faq_in').html(fhtml);
        } else {
          $('#vps7_faq_in').html('<div style="opacity:.7;padding:6px">سوالات متداولی موجود نیست.</div>');
        }

        // پیش‌نمایش
        if(res.preview_url && $('#vps7_preview_link').length){ $('#vps7_preview_link').attr('href', res.preview_url); }
        if(res.preview_url && !$('.vps7-tabbtn[data-tab="prev"]').length && type==='theme'){
          $('.vps7-tabsline').append('<button type="button" class="vps7-tabbtn" data-tab="prev" data-href="'+res.preview_url+'">پیش‌نمایش</button>');
        }
      })
      .fail(function(xhr){
        var code = (xhr && xhr.status) ? (' ['+xhr.status+']') : '';
        showApiError('امکان دریافت جزئیات از API نیست'+code+'؛ بعداً دوباره تلاش کنید.');
      });
  }

  /* ---------- Trigger ---------- */

  $(document).on('click', '.vps7-details', function(e){
    e.preventDefault();

    var t    = $(this);
    var box  = t.closest('[data-id], [data-post-id], [data-post]');
    var list = $('#vps7_list');

    var id = t.data('id') || (box.length? (box.data('id')||box.data('postId')||box.data('post')) : 0) || t.data('postId') || t.data('post') || 0;
    if(!id){
      var href = t.attr('href')||'';
      var m = href.match(/[?&](?:id|post_id|post)=([0-9]+)/i);
      if(m) id = parseInt(m[1],10);
    }
    id = parseInt(id,10)||0;

    var type = (t.data('type') || list.data('type') || (box.length? box.data('type') : '') || $('body').data('vps7Type') || '').toString().toLowerCase();
    if(type!=='theme') type='plugin';

    var payload = {
      title  : t.data('title')   || (box.data('title')||''),
      img    : t.data('img')     || (box.data('img')||''),
      ver    : t.data('ver')     || (box.data('ver')||''),
      udate  : t.data('udate')   || (box.data('udate')||''),
      dl     : t.data('dl')      || (box.data('dl')||0),
      excerpt: t.data('excerpt') || (box.data('excerpt')||''),
      isTheme: (type==='theme'),
      preview: t.data('preview') || (box.data('preview')||'')
    };

    var html = buildModalSkeleton(payload);
    openModal(html);

    $('#vps7_tab_desc_in').html(t.data('full') || (box.data('full')||''));

    hydrateFromAPI(id, type);
  });

})(jQuery);
JS;
    wp_add_inline_script('vps7-details-js', $js);
});
