<?php
// vps7-client-updates.php (ONLY updates page)
if (!defined('ABSPATH')) exit;
if (defined('VPS7_CLIENT_UPDATES')) return;
define('VPS7_CLIENT_UPDATES', '1.2.5');

/* --------- Menu --------- */
add_action('admin_menu', function () {
    add_submenu_page(
        'vps7_client',
        'بروزرسانی',
        'بروزرسانی',
        'install_plugins',
        'vps7_updates',
        'vps7_updates_page'
    );
});

/* --------- Helpers --------- */
function vps7_up_api_root() {
    if (class_exists('VPS7_Repository_Client')) {
        return rtrim(VPS7_Repository_Client::SERVER_BASE, '/') . '/' . ltrim(VPS7_Repository_Client::API_BASE, '/');
    }
    return 'https://vps7.net/wp-json/vps7/v1';
}
function vps7_up_license_opt_key() {
    return class_exists('VPS7_Repository_Client') ? VPS7_Repository_Client::OPT_LICENSE : 'vps7_client_license';
}
function vps7_up_remote_get($url, $args = array()) {
    $url = add_query_arg($args, $url);
    $r = wp_remote_get($url, array('timeout' => 20));
    if (is_wp_error($r)) return array();
    $b = wp_remote_retrieve_body($r);
    $d = json_decode($b, true);
    return is_array($d) ? $d : array();
}

/** دسترسی IP-اول (سخت‌گیرانه و بدون کش) */
function vps7_up_check_access_strict(){
    $api     = vps7_up_api_root();
    $opt_key = vps7_up_license_opt_key();
    $license = trim(get_option($opt_key, ''));
    $domain  = parse_url(site_url(), PHP_URL_HOST);

    // 1) IP
    $probe = vps7_up_remote_get($api.'/access', array(
        'intent'     => 'connect',
        'consume'    => 0,
        'require_ip' => 1,
        'domain'     => $domain,
        'nocache'    => uniqid('', true),
    ));
    if (is_array($probe) && !empty($probe['allowed']) && strtolower((string)($probe['via'] ?? 'ip')) === 'ip') {
        return array('allowed'=>true, 'via'=>'ip');
    }

    // 2) License
    if ($license !== '') {
        $acc = vps7_up_remote_get($api.'/access', array(
            'license' => $license,
            'domain'  => $domain,
            'intent'  => 'connect',
            'consume' => 0,
            'nocache' => uniqid('', true),
        ));
        if (is_array($acc) && (!empty($acc['fatal']) || !empty($acc['domain_unbound']) || !empty($acc['invalidate']) || !empty($acc['should_unset']))) {
            delete_option($opt_key);
            return array('allowed'=>false, 'via'=>'license');
        }
        if (is_array($acc) && !empty($acc['allowed'])) {
            return array('allowed'=>true, 'via'=>'license');
        }
        return array('allowed'=>false, 'via'=>'license');
    }

    return array('allowed'=>false, 'via'=>'ip');
}

function vps7_up_fetch_all($type = 'plugin') {
    $api = vps7_up_api_root();
    $endpoint = $api . ($type === 'theme' ? '/themes' : '/plugins');
    $all = array(); $page = 1; $pages = 1; $hard_cap = 50;
    do {
        $res = vps7_up_remote_get($endpoint, array('page' => $page, 'per_page' => 50));
        if (is_array($res) && !empty($res['items'])) $all = array_merge($all, $res['items']);
        $pages = max($pages, intval(isset($res['pages']) ? $res['pages'] : $page));
        $page++;
    } while ($page <= $pages && $page <= $hard_cap);
    return $all;
}
function vps7_up_excerpt($txt) {
    $t = wp_strip_all_tags((string)$txt);
    if (function_exists('mb_substr')) {
        $e = mb_substr($t, 0, 150, 'UTF-8'); $more = (mb_strlen($t, 'UTF-8') > 150) ? '…' : '';
    } else { $e = substr($t, 0, 150); $more = (strlen($t) > 150) ? '…' : ''; }
    return $e . $more;
}
function vps7_up_g2j_php($gy,$gm,$gd,$as_string=true){
    $gdm=[31,28,31,30,31,30,31,31,30,31,30,31]; $jdm=[31,31,31,31,31,31,30,30,30,30,30,29];
    $gy2=$gy-1600; $gm2=$gm-1; $gd2=$gd-1;
    $g=365*$gy2+intdiv($gy2+3,4)-intdiv($gy2+99,100)+intdiv($gy2+399,400);
    for($i=0;$i<$gm2;$i++) $g+=$gdm[$i];
    if($gm2>1 && (($gy%4==0 && $gy%100!=0) || ($gy%400==0))) $g++;
    $g+=$gd2; $j=$g-79; $jp=intdiv($j,12053); $j%=12053;
    $jy=979+33*$jp+4*intdiv($j,1461); $j%=1461;
    if($j>=366){ $jy+=intdiv($j-1,365); $j=($j-1)%365; }
    for($i=0;$i<11 && $j>=$jdm[$i];$i++) $j-=$jdm[$i];
    $jm=$i+1; $jd=$j+1; return $as_string?sprintf('%04d/%02d/%02d',$jy,$jm,$jd):[$jy,$jm,$jd];
}
function vps7_up_normalize_updated($u){
    if(!$u) return '';
    if(preg_match('/^\d{4}-\d{2}-\d{2}/', $u)){
        $d = explode('T',$u)[0]; list($gy,$gm,$gd) = array_map('intval', explode('-',$d));
        return vps7_up_g2j_php($gy,$gm,$gd,true);
    }
    return $u;
}

/* --------- Renderers --------- */
function vps7_up_render_plugins($items, $allowed){
    if (empty($items)) { echo '<p>موردی یافت نشد.</p>'; return; }
    foreach ($items as $it) {
        $img         = esc_url(!empty($it['thumbnail']) ? $it['thumbnail'] : 'https://s.w.org/images/core/emoji/14.0.0/svg/1f4e6.svg');
        $title       = esc_html($it['title']);
        $updated_d   = vps7_up_normalize_updated(isset($it['updated_at']) ? $it['updated_at'] : '');
        $ver         = isset($it['version']) ? (string)$it['version'] : '';
        $dl          = intval(isset($it['downloads']) ? $it['downloads'] : 0);
        $excerpt_html= esc_html(vps7_up_excerpt(isset($it['excerpt']) ? $it['excerpt'] : ''));
        $content_attr= esc_attr(isset($it['content']) ? $it['content'] : '');
        $slug        = esc_attr( !empty($it['slug']) ? sanitize_title($it['slug']) : sanitize_title($it['title']) );

        $disabled_attr = $allowed ? '' : ' disabled';
        $aria_disabled = $allowed ? 'false' : 'true';

        echo <<<HTML
<div class="vps7-card" data-id="{$it['id']}" data-version="{$ver}" data-title="{$title}" data-slug="{$slug}">
    <div class="vps7-thumbcol">
        <img src="{$img}" alt="">
        <div class="vps7-underimg">
            <a href="#" class="button-link vps7-details"
               data-full="{$content_attr}"
               data-title="{$title}"
               data-img="{$img}">جزئیات</a>
        </div>
    </div>
    <div>
        <h3>{$title}</h3>
        <div class="vps7-excerpt">{$excerpt_html}</div>
        <div class="vps7-chips">
            <a class="button vps7-pill vps7-pill--green">نسخه {$ver}</a>
            <a class="button vps7-pill vps7-pill--red">بروزرسانی {$updated_d}</a>
        </div>
    </div>
    <div class="vps7-actions">
        <button class="button button-primary vps7-install"{$disabled_attr} data-type="plugin" aria-disabled="{$aria_disabled}">بروزرسانی</button>
        <a class="button vps7-pill vps7-pill--blue">دانلود {$dl}</a>
    </div>
</div>
HTML;
    }
}

function vps7_up_render_themes($items, $allowed){
    if (empty($items)) { echo '<p>موردی یافت نشد.</p>'; return; }
    foreach ($items as $it) {
        $img         = esc_url(!empty($it['thumbnail']) ? $it['thumbnail'] : 'https://s.w.org/images/core/emoji/14.0.0/svg/1f4f7.svg');
        $title       = esc_html($it['title']);
        $updated_d   = vps7_up_normalize_updated(isset($it['updated_at']) ? $it['updated_at'] : '');
        $ver         = isset($it['version']) ? (string)$it['version'] : '';
        $dl          = intval(isset($it['downloads']) ? $it['downloads'] : 0);
        $content_attr= esc_attr(isset($it['content']) ? $it['content'] : '');
        $slug        = esc_attr( !empty($it['slug']) ? sanitize_title($it['slug']) : sanitize_title($it['title']) );

        $disabled_attr = $allowed ? '' : ' disabled';
        $aria_disabled = $allowed ? 'false' : 'true';

        echo <<<HTML
<div class="vps7-theme" data-id="{$it['id']}" data-version="{$ver}" data-title="{$title}" data-slug="{$slug}">
    <img src="{$img}" alt="">
    <div class="meta">
        <a class="button vps7-pill vps7-pill--green">نسخه {$ver}</a>
        <a class="button vps7-pill vps7-pill--red">بروزرسانی {$updated_d}</a>
        <a class="button vps7-pill vps7-pill--blue">دانلود {$dl}</a>
        <button class="button button-primary vps7-install"{$disabled_attr} data-type="theme" aria-disabled="{$aria_disabled}">بروزرسانی</button>
    </div>
    <div class="split">
        <a href="#" class="right vps7-details"
           data-full="{$content_attr}"
           data-title="{$title}"
           data-img="{$img}">جزئیات قالب</a>
        <a href="#" class="middle vps7-preview" data-img="{$img}" data-title="{$title}">پیش‌نمایش قالب</a>
        <span class="left" style="opacity:.6;cursor:not-allowed">صفحه قالب</span>
    </div>
</div>
HTML;
    }
}

/* --------- Page --------- */
function vps7_updates_page() {
    $acc     = vps7_up_check_access_strict();
    $allowed = !empty($acc['allowed']);
    $via     = (string)($acc['via'] ?? '');

    // داده‌های مخزن
    $repo_plugins = vps7_up_fetch_all('plugin');
    $repo_themes  = vps7_up_fetch_all('theme');

    // فقط چیزهایی که آپدیت دارند
    require_once ABSPATH.'wp-admin/includes/plugin.php';
    $installed_plugin_versions = array();
    foreach (get_plugins() as $file=>$data) {
        $folder = explode('/', $file)[0];
        $ver = isset($data['Version']) ? $data['Version'] : '';
        $installed_plugin_versions[ sanitize_title($folder) ] = $ver;
        $installed_plugin_versions[ sanitize_title($data['Name']) ] = $ver;
    }
    $installed_theme_versions = array();
    foreach (wp_get_themes() as $ss=>$th){
        $installed_theme_versions[ sanitize_title($ss) ] = $th->get('Version');
        $installed_theme_versions[ sanitize_title($th->get('Name')) ] = $th->get('Version');
    }

    $plugins_filtered = array();
    foreach ($repo_plugins as $it){
        $slug = sanitize_title(!empty($it['slug']) ? $it['slug'] : $it['title']);
        $remote_ver = isset($it['version']) ? trim((string)$it['version']) : '';
        if ($remote_ver === '') continue;
        if (!isset($installed_plugin_versions[$slug])) continue;
        $local_ver = trim((string)$installed_plugin_versions[$slug]);
        if ($local_ver === '') continue;
        if (version_compare($remote_ver, $local_ver, '>')) $plugins_filtered[] = $it;
    }

    $themes_filtered = array();
    foreach ($repo_themes as $it){
        $slug = sanitize_title(!empty($it['slug']) ? $it['slug'] : $it['title']);
        $remote_ver = isset($it['version']) ? trim((string)$it['version']) : '';
        if ($remote_ver === '') continue;
        if (!isset($installed_theme_versions[$slug])) continue;
        $local_ver = trim((string)$installed_theme_versions[$slug]);
        if ($local_ver === '') continue;
        if (version_compare($remote_ver, $local_ver, '>')) $themes_filtered[] = $it;
    }

    echo '<div class="wrap vps7-page">';
    echo '<h1>بروزرسانی</h1>';

    // استایل و کلاس‌ها
    echo '<style>
      .vps7-infobox{display:flex;gap:12px;align-items:flex-start;border:1px solid #e5e7eb;background:#fff;border-radius:10px;padding:12px 14px;margin:10px 0 14px 0}
      .vps7-ok{border-color:#22c55e;background:#ecfdf5}
      .vps7-warn{border-color:#f97316;background:#fff7ed}
      .vps7-err{border-color:#ef4444;background:#fef2f2}
      .vps7-ico{flex:0 0 28px;width:28px;height:28px;border-radius:50%;display:flex;align-items:center;justify-content:center;margin-top:2px}
      .vps7-ok .vps7-ico{background:#22c55e;color:#fff}
      .vps7-warn .vps7-ico{background:#f97316;color:#fff}
      .vps7-err .vps7-ico{background:#ef4444;color:#fff}
      .vps7-infobox h3{margin:0 0 6px 0;font-size:15px}
      .vps7-infobox p{margin:0}
      .button.vps7-install[disabled]{opacity:.45;cursor:not-allowed}
    </style>';

    // آیکن‌ها
    $svg_check = '<svg viewBox="0 0 24 24" width="18" height="18" fill="currentColor"><path d="M9 16.2l-3.5-3.5L4 14.2l5 5 11-11-1.5-1.5z"/></svg>';
    $svg_warn  = '<svg viewBox="0 0 24 24" width="18" height="18" fill="currentColor"><path d="M1 21h22L12 2 1 21zm11-9h2v5h-2zm0 6h2v2h-2z"/></svg>';

    // بنر وضعیت: IP و لایسنس هر دو سبز
    if ($allowed && ($via === 'ip' || $via === 'license')) {
        $title = ($via === 'ip') ? 'دسترسی IP شما مجاز است' : 'دسترسی با لایسنس معتبر';
        $desc  = ($via === 'ip') ? 'نیازی به ثبت لایسنس نیست.' : 'این دسترسی به‌واسطهٔ لایسنس فعال شده است.';
        echo '<div class="vps7-infobox vps7-ok">
                <div class="vps7-ico">'.$svg_check.'</div>
                <div><h3>'.$title.'</h3><p>'.$desc.'</p></div>
              </div>';
    } else {
        $shop_link     = esc_url('https://vps7.net/shop');
        $settings_link = esc_url(admin_url('admin.php?page=vps7_settings'));
        echo '<div class="vps7-infobox vps7-err">
                <div class="vps7-ico">'.$svg_warn.'</div>
                <div>
                  <h3>دسترسی شما مجاز نیست</h3>
                  <p>شما اجازه دسترسی به ریپازیتوری VPS 7 ندارید. برای فعال‌سازی دسترسی از طریق لایسنس به <a href="'.$settings_link.'">بخش لایسنس</a> مراجعه کنید، و برای خرید لایسنس به <a href="'.$shop_link.'" target="_blank" rel="noopener">VPS 7</a> مراجعه کنید.</p>
                </div>
              </div>';
    }

    echo '<p>در این صفحه فقط افزونه‌ها و قالب‌هایی نمایش داده می‌شوند که نسخهٔ جدیدتری نسبت به نسخهٔ نصب‌شده دارند.</p>';

    echo '<h2 style="margin-top:20px">افزونه‌هایی که بروزرسانی دارند</h2>';
    echo '<div class="vps7-list vps7-list--plugin">';
    vps7_up_render_plugins($plugins_filtered, $allowed);
    echo '</div>';

    echo '<h2 style="margin-top:30px">قالب‌هایی که بروزرسانی دارند</h2>';
    echo '<div class="vps7-list vps7-list--theme">';
    vps7_up_render_themes($themes_filtered, $allowed);
    echo '</div>';

    if (empty($plugins_filtered) && empty($themes_filtered)) {
        echo '<div class="vps7-infobox vps7-ok">
                <div class="vps7-ico">'.$svg_check.'</div>
                <div><h3>همه‌چیز به‌روز است</h3><p>تبریک! همهٔ افزونه‌ها و قالب‌های نصب‌شده شما به‌روز هستند.</p></div>
              </div>';
    }

    // JS: تنظیم وضعیت دکمه‌ها و بلاک کلیک در حالت غیرمجاز + رصد اضافه‌شدن نودهای جدید
    $allowed_js = $allowed ? 'true' : 'false';
    $block_msg  = esc_js('دسترسی شما به ریپازیتوری VPS 7 مجاز نیست. برای فعال‌سازی از بخش لایسنس اقدام کنید.');
    echo <<<HTML
<script>
  window.VPS7 = window.VPS7 || {};
  VPS7.allowed = {$allowed_js};

  (function($){
    $(function(){
      var BLOCK_MSG = "{$block_msg}";

      function setButtonsState(isAllowed, scope){
        var \$root = scope ? $(scope) : $(document);
        var \$btns = \$root.find(".vps7-install");
        if (isAllowed) {
          \$btns.prop("disabled", false).attr("aria-disabled", "false").removeAttr("title");
        } else {
          \$btns.prop("disabled", true).attr("aria-disabled", "true").attr("title", BLOCK_MSG);
        }
      }

      // ست اولیه
      setButtonsState(!!VPS7.allowed);

      // بلاک کلیک در حالت غیرمجاز
      $(document).on("click", ".vps7-install", function(e){
        if (!VPS7.allowed) {
          e.preventDefault();
          e.stopImmediatePropagation();
          window.alert(BLOCK_MSG);
          return false;
        }
      });

      // رصد اضافه‌شدن نودهای جدید (بدون گوش دادن به attributes برای جلوگیری از لوپ)
      var observer = new MutationObserver(function(mutations){
        for (var i=0; i<mutations.length; i++){
          var m = mutations[i];
          if (m.type === "childList" && m.addedNodes && m.addedNodes.length){
            for (var j=0; j<m.addedNodes.length; j++){
              var node = m.addedNodes[j];
              if (node && node.nodeType === 1) {
                var \$node = $(node);
                if (\$node.is(".vps7-install") || \$node.find(".vps7-install").length){
                  setButtonsState(!!VPS7.allowed, \$node);
                }
              }
            }
          }
        }
      });

      observer.observe(document.body, { childList: true, subtree: true });
    });
  })(jQuery);
</script>
HTML;

    echo '</div>'; // .wrap
}
